/*
 * Decompiled with CFR 0.152.
 */
package mandelbrot;

import com.imsl.math.Complex;
import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Graphics;
import mandelbrot.Engine;
import mandelbrot.JuliaEngine;
import mandelbrot.MandelEngine;
import mandelbrot.SpecialPlace;

public class QuarterCanvas
extends Canvas {
    public static int canvasSize = 256;
    private Engine engine;
    private boolean is_sinz;
    private boolean is_ez;
    private boolean is_zz;
    private boolean is_zi;

    QuarterCanvas() {
        this.engine = this.setEngineM(SpecialPlace.rec[0].n_iter, SpecialPlace.rec[0].zmin, SpecialPlace.rec[0].zsize, SpecialPlace.rec[0].pow);
    }

    public Dimension getPreferredSize() {
        return new Dimension(canvasSize, canvasSize);
    }

    public void setEqn(boolean sinz, boolean ez, boolean zz, boolean zi) {
        this.is_sinz = sinz;
        this.is_ez = ez;
        this.is_zz = zz;
        this.is_zi = zi;
    }

    public void redrawM(int n, Complex zmin, double zsize, double pow) {
        this.engine = this.setEngineM(n, zmin, zsize, pow);
        this.repaint();
    }

    public void redrawJ(int n, Complex zmin, double zsize, Complex c, double pow) {
        this.engine = this.setEngineJ(n, zmin, zsize, c, pow);
        this.repaint();
    }

    public void paint(Graphics g) {
        if (this.engine == null) {
            return;
        }
        this.engine.setEqn(this.is_sinz, this.is_ez, this.is_zz, this.is_zi);
        this.engine.paint(g);
    }

    private Engine setEngineM(int n, Complex zmin, double zsize, double pow) {
        return new MandelEngine(n, zmin, zsize, pow, canvasSize);
    }

    private Engine setEngineJ(int n, Complex zmin, double zsize, Complex c, double pow) {
        return new JuliaEngine(n, zmin, zsize, c, pow, canvasSize);
    }
}

