/*
 * Decompiled with CFR 0.152.
 */
package com.imsl.math;

import com.imsl.math.Sfun;
import java.io.Serializable;

public class Complex
implements Serializable,
Cloneable {
    private double re;
    private double im;
    static final long serialVersionUID = -633126172485117692L;
    public static String suffix;
    private static final long negZeroBits;

    public Complex(Complex z) {
        this.re = z.re;
        this.im = z.im;
    }

    public Complex(double re, double im) {
        this.re = re;
        this.im = im;
    }

    public Complex(double re) {
        this.re = re;
        this.im = 0.0;
    }

    public Complex() {
        this.re = 0.0;
        this.im = 0.0;
    }

    private boolean isNaN() {
        return Double.isNaN(this.re) || Double.isNaN(this.im);
    }

    public boolean equals(Complex z) {
        if (this.isNaN() && z.isNaN()) {
            return true;
        }
        return this.re == z.re && this.im == z.im;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Complex) {
            return this.equals((Complex)obj);
        }
        return false;
    }

    public int hashCode() {
        long re_bits = Double.doubleToLongBits(this.re);
        long im_bits = Double.doubleToLongBits(this.im);
        return (int)(re_bits ^ im_bits ^ (re_bits ^ im_bits) >> 32);
    }

    public double real() {
        return this.re;
    }

    public double imag() {
        return this.im;
    }

    public static double real(Complex z) {
        return z.re;
    }

    public static double imag(Complex z) {
        return z.im;
    }

    public static Complex negative(Complex z) {
        return new Complex(-z.re, -z.im);
    }

    public static Complex conjugate(Complex z) {
        return new Complex(z.re, -z.im);
    }

    public static Complex plus(Complex x, Complex y) {
        return new Complex(x.re + y.re, x.im + y.im);
    }

    public static Complex plus(Complex x, double y) {
        return new Complex(x.re + y, x.im);
    }

    public static Complex plus(double x, Complex y) {
        return new Complex(x + y.re, y.im);
    }

    public Complex plus(Complex y) {
        return new Complex(this.re + y.re, this.im + y.im);
    }

    public Complex plus(double y) {
        return new Complex(this.re + y, this.im);
    }

    public Complex plusReverse(double x) {
        return new Complex(this.re + x, this.im);
    }

    public static Complex minus(Complex x, Complex y) {
        return new Complex(x.re - y.re, x.im - y.im);
    }

    public static Complex minus(Complex x, double y) {
        return new Complex(x.re - y, x.im);
    }

    public static Complex minus(double x, Complex y) {
        return new Complex(x - y.re, -y.im);
    }

    public Complex minus(Complex y) {
        return new Complex(this.re - y.re, this.im - y.im);
    }

    public Complex minus(double y) {
        return new Complex(this.re - y, this.im);
    }

    public Complex minusReverse(double x) {
        return new Complex(x - this.re, -this.im);
    }

    public static Complex times(Complex x, Complex y) {
        Complex t = new Complex(x.re * y.re - x.im * y.im, x.re * y.im + x.im * y.re);
        if (Double.isNaN(t.re) && Double.isNaN(t.im)) {
            Complex.timesNaN(x, y, t);
        }
        return t;
    }

    private static double copysign(double a, double b) {
        double abs = Math.abs(a);
        return b < 0.0 ? -abs : abs;
    }

    private static void timesNaN(Complex x, Complex y, Complex t) {
        boolean recalc = false;
        double a = x.re;
        double b = x.im;
        double c = y.re;
        double d = y.im;
        if (Double.isInfinite(a) || Double.isInfinite(b)) {
            a = Complex.copysign(Double.isInfinite(a) ? 1.0 : 0.0, a);
            b = Complex.copysign(Double.isInfinite(b) ? 1.0 : 0.0, b);
            if (Double.isNaN(c)) {
                c = Complex.copysign(0.0, c);
            }
            if (Double.isNaN(d)) {
                d = Complex.copysign(0.0, d);
            }
            recalc = true;
        }
        if (Double.isInfinite(c) || Double.isInfinite(d)) {
            a = Complex.copysign(Double.isInfinite(c) ? 1.0 : 0.0, c);
            b = Complex.copysign(Double.isInfinite(d) ? 1.0 : 0.0, d);
            if (Double.isNaN(a)) {
                a = Complex.copysign(0.0, a);
            }
            if (Double.isNaN(b)) {
                b = Complex.copysign(0.0, b);
            }
            recalc = true;
        }
        if (!recalc && (Double.isInfinite(a * c) || Double.isInfinite(b * d) || Double.isInfinite(a * d) || Double.isInfinite(b * c))) {
            if (Double.isNaN(a)) {
                a = Complex.copysign(0.0, a);
            }
            if (Double.isNaN(b)) {
                b = Complex.copysign(0.0, b);
            }
            if (Double.isNaN(c)) {
                c = Complex.copysign(0.0, c);
            }
            if (Double.isNaN(d)) {
                d = Complex.copysign(0.0, d);
            }
            recalc = true;
        }
        if (recalc) {
            t.re = Double.POSITIVE_INFINITY * (a * c - b * d);
            t.im = Double.POSITIVE_INFINITY * (a * d + b * c);
        }
    }

    public static Complex times(Complex x, double y) {
        return new Complex(x.re * y, x.im * y);
    }

    public static Complex times(double x, Complex y) {
        return new Complex(x * y.re, x * y.im);
    }

    public Complex times(Complex y) {
        return Complex.times(this, y);
    }

    public Complex times(double y) {
        return new Complex(this.re * y, this.im * y);
    }

    public Complex timesReverse(double x) {
        return new Complex(x * this.re, x * this.im);
    }

    private static boolean isFinite(double x) {
        return !Double.isInfinite(x) && !Double.isNaN(x);
    }

    public static Complex over(Complex x, Complex y) {
        double a = x.re;
        double b = x.im;
        double c = y.re;
        double d = y.im;
        double scale = Math.max(Math.abs(c), Math.abs(d));
        boolean isScaleFinite = Complex.isFinite(scale);
        if (isScaleFinite) {
            c /= scale;
            d /= scale;
        }
        double den = c * c + d * d;
        Complex z = new Complex((a * c + b * d) / den, (b * c - a * d) / den);
        if (isScaleFinite) {
            z.re /= scale;
            z.im /= scale;
        }
        if (Double.isNaN(z.re) && Double.isNaN(z.im)) {
            if (!(den != 0.0 || Double.isNaN(a) && Double.isNaN(b))) {
                double s = Complex.copysign(Double.POSITIVE_INFINITY, c);
                z.re = s * a;
                z.im = s * b;
            } else if ((Double.isInfinite(a) || Double.isInfinite(b)) && Complex.isFinite(c) && Complex.isFinite(d)) {
                a = Complex.copysign(Double.isInfinite(a) ? 1.0 : 0.0, a);
                b = Complex.copysign(Double.isInfinite(b) ? 1.0 : 0.0, b);
                z.re = Double.POSITIVE_INFINITY * (a * c + b * d);
                z.im = Double.POSITIVE_INFINITY * (b * c - a * d);
            } else if (Double.isInfinite(scale) && Complex.isFinite(a) && Complex.isFinite(b)) {
                c = Complex.copysign(Double.isInfinite(c) ? 1.0 : 0.0, c);
                d = Complex.copysign(Double.isInfinite(d) ? 1.0 : 0.0, d);
                z.re = 0.0 * (a * c + b * d);
                z.im = 0.0 * (b * c - a * d);
            }
        }
        return z;
    }

    public static Complex over(Complex x, double y) {
        return new Complex(x.re / y, x.im / y);
    }

    public static Complex over(double x, Complex y) {
        return y.overReverse(x);
    }

    public Complex over(Complex y) {
        return Complex.over(this, y);
    }

    public Complex over(double y) {
        return Complex.over(this, y);
    }

    public Complex overReverse(double x) {
        Complex z;
        if (Math.abs(this.re) > Math.abs(this.im)) {
            double t = this.im / this.re;
            double den = this.re + this.im * t;
            z = new Complex(x / den, -x * t / den);
        } else {
            double t = this.re / this.im;
            double den = this.im + this.re * t;
            z = new Complex(x * t / den, -x / den);
        }
        return z;
    }

    public static double abs(Complex z) {
        double x = Math.abs(z.re);
        double y = Math.abs(z.im);
        if (Double.isInfinite(x) || Double.isInfinite(y)) {
            return Double.POSITIVE_INFINITY;
        }
        if (x + y == 0.0) {
            return 0.0;
        }
        if (x > y) {
            return x * Math.sqrt(1.0 + (y /= x) * y);
        }
        return y * Math.sqrt((x /= y) * x + 1.0);
    }

    public static double argument(Complex z) {
        return Math.atan2(z.im, z.re);
    }

    public static Complex sqrt(Complex z) {
        Complex result = new Complex();
        if (Double.isInfinite(z.im)) {
            result.re = Double.POSITIVE_INFINITY;
            result.im = z.im;
        } else if (Double.isNaN(z.re)) {
            result.im = Double.NaN;
            result.re = Double.NaN;
        } else if (Double.isNaN(z.im)) {
            if (Double.isInfinite(z.re)) {
                if (z.re > 0.0) {
                    result.re = z.re;
                    result.im = z.im;
                } else {
                    result.re = z.im;
                    result.im = Double.POSITIVE_INFINITY;
                }
            } else {
                result.im = Double.NaN;
                result.re = Double.NaN;
            }
        } else {
            double t = Complex.abs(z);
            if (Math.abs(z.re) <= Math.abs(z.im)) {
                result.re = Math.sqrt(0.5 * (t + z.re));
                result.im = Math.sqrt(0.5 * (t - z.re));
            } else if (z.re > 0.0) {
                result.re = t + z.re;
                result.im = Math.abs(z.im) * Math.sqrt(0.5 / result.re);
                result.re = Math.sqrt(0.5 * result.re);
            } else {
                result.im = t - z.re;
                result.re = Math.abs(z.im) * Math.sqrt(0.5 / result.im);
                result.im = Math.sqrt(0.5 * result.im);
            }
            if (z.im < 0.0) {
                result.im = -result.im;
            }
        }
        return result;
    }

    public static Complex exp(Complex z) {
        Complex result = new Complex();
        double r = Math.exp(z.re);
        double cosa = Math.cos(z.im);
        double sina = Math.sin(z.im);
        if (Double.isInfinite(z.im) || Double.isNaN(z.im) || Math.abs(cosa) > 1.0) {
            sina = Double.NaN;
            cosa = Double.NaN;
        }
        if (Double.isInfinite(z.re) || Double.isInfinite(r)) {
            if (z.re < 0.0) {
                r = 0.0;
                if (Double.isInfinite(z.im) || Double.isNaN(z.im)) {
                    sina = 0.0;
                    cosa = 0.0;
                } else {
                    cosa /= Double.POSITIVE_INFINITY;
                    sina /= Double.POSITIVE_INFINITY;
                }
            } else {
                r = z.re;
                if (Double.isNaN(z.im)) {
                    cosa = 1.0;
                }
            }
        }
        if (z.im == 0.0) {
            result.re = r;
            result.im = z.im;
        } else {
            result.re = r * cosa;
            result.im = r * sina;
        }
        return result;
    }

    public static Complex log(Complex z) {
        Complex result = new Complex();
        if (Double.isNaN(z.re)) {
            result.re = result.im = z.re;
            if (Double.isInfinite(z.im)) {
                result.re = Double.POSITIVE_INFINITY;
            }
        } else if (Double.isNaN(z.im)) {
            result.re = result.im = z.im;
            if (Double.isInfinite(z.re)) {
                result.re = Double.POSITIVE_INFINITY;
            }
        } else {
            result.re = Math.log(Complex.abs(z));
            result.im = Complex.argument(z);
        }
        return result;
    }

    public static Complex sin(Complex z) {
        Complex iz = new Complex(-z.im, z.re);
        Complex s = Complex.sinh(iz);
        double re = s.im;
        s.im = -s.re;
        s.re = re;
        return s;
    }

    public static Complex cos(Complex z) {
        return Complex.cosh(new Complex(-z.im, z.re));
    }

    public static Complex tan(Complex z) {
        Complex iz = new Complex(-z.im, z.re);
        Complex s = Complex.tanh(iz);
        double re = s.im;
        s.im = -s.re;
        s.re = re;
        return s;
    }

    public static Complex asin(Complex z) {
        Complex result = new Complex();
        double r = Complex.abs(z);
        if (Double.isInfinite(r)) {
            boolean infiniteX = Double.isInfinite(z.re);
            boolean infiniteY = Double.isInfinite(z.im);
            if (infiniteX) {
                double pi2 = 1.5707963267948966;
                double d = result.re = z.re > 0.0 ? pi2 : -pi2;
                if (infiniteY) {
                    result.re /= (double)2;
                }
            } else if (infiniteY) {
                result.re = z.re / Double.POSITIVE_INFINITY;
            }
            if (Double.isNaN(z.im)) {
                result.im = -z.re;
                result.re = z.im;
            } else {
                result.im = z.im * Double.POSITIVE_INFINITY;
            }
            return result;
        }
        if (Double.isNaN(r)) {
            result.im = Double.NaN;
            result.re = Double.NaN;
            if (z.re == 0.0) {
                result.re = z.re;
            }
        } else if (r < 2.58095E-8) {
            result.re = z.re;
            result.im = z.im;
        } else if (z.re == 0.0) {
            result.re = 0.0;
            result.im = Sfun.asinh(z.im);
        } else if (r <= 0.1) {
            Complex z2 = Complex.times(z, z);
            for (int i = 1; i <= 8; ++i) {
                double twoi = 2 * (8 - i) + 1;
                result = Complex.times(Complex.times(result, z2), twoi / (twoi + 1.0));
                result.re += 1.0 / twoi;
            }
            result = result.times(z);
        } else {
            Complex w = z.im < 0.0 ? Complex.negative(z) : z;
            Complex sqzp1 = Complex.sqrt(Complex.plus(w, 1.0));
            if (sqzp1.im < 0.0) {
                sqzp1 = Complex.negative(sqzp1);
            }
            Complex sqzm1 = Complex.sqrt(Complex.minus(w, 1.0));
            result = Complex.log(Complex.plus(w, Complex.times(sqzp1, sqzm1)));
            double rx = result.re;
            result.re = 1.5707963267948966 + result.im;
            result.im = -rx;
        }
        if (result.re > 1.5707963267948966) {
            result.re = Math.PI - result.re;
            result.im = -result.im;
        }
        if (result.re < -1.5707963267948966) {
            result.re = -Math.PI - result.re;
            result.im = -result.im;
        }
        if (z.im < 0.0) {
            result.re = -result.re;
            result.im = -result.im;
        }
        return result;
    }

    public static Complex acos(Complex z) {
        Complex result = new Complex();
        double r = Complex.abs(z);
        if (Double.isInfinite(z.re) && Double.isNaN(z.im)) {
            result.re = Double.NaN;
            result.im = Double.NEGATIVE_INFINITY;
        } else if (Double.isInfinite(r)) {
            result.re = Math.atan2(Math.abs(z.im), z.re);
            result.im = z.im * Double.NEGATIVE_INFINITY;
        } else if (r == 0.0) {
            result.re = 1.5707963267948966;
            result.im = -z.im;
        } else {
            result = Complex.minus(1.5707963267948966, Complex.asin(z));
        }
        return result;
    }

    public static Complex atan(Complex z) {
        Complex result = new Complex();
        double r = Complex.abs(z);
        if (Double.isInfinite(r)) {
            double pi2 = 1.5707963267948966;
            double im = Double.isNaN(z.im) ? 0.0 : z.im;
            result.re = z.re < 0.0 ? -pi2 : pi2;
            result.im = (double)(im < 0.0 ? -1 : 1) / Double.POSITIVE_INFINITY;
            if (Double.isNaN(z.re)) {
                result.re = z.re;
            }
        } else if (Double.isNaN(r)) {
            result.im = Double.NaN;
            result.re = Double.NaN;
            if (z.im == 0.0) {
                result.im = z.im;
            }
        } else if (r < 1.82501E-8) {
            result.re = z.re;
            result.im = z.im;
        } else if (r < 0.1) {
            Complex z2 = Complex.times(z, z);
            for (int k = 0; k < 17; ++k) {
                Complex temp = Complex.times(z2, result);
                int twoi = 2 * (17 - k) - 1;
                result.re = 1.0 / (double)twoi - temp.re;
                result.im = -temp.im;
            }
            result = result.times(z);
        } else if (r < 9.0072E15) {
            double r2 = r * r;
            result.re = 0.5 * Math.atan2((double)2 * z.re, 1.0 - r2);
            result.im = 0.25 * Math.log((r2 + (double)2 * z.im + 1.0) / (r2 - (double)2 * z.im + 1.0));
        } else {
            result.re = z.re < 0.0 ? -1.5707963267948966 : 1.5707963267948966;
        }
        return result;
    }

    public static Complex sinh(Complex z) {
        Complex result;
        double coshx = Sfun.cosh(z.re);
        double sinhx = Sfun.sinh(z.re);
        double cosy = Math.cos(z.im);
        double siny = Math.sin(z.im);
        boolean infiniteX = Double.isInfinite(coshx);
        boolean infiniteY = Double.isInfinite(z.im);
        if (z.im == 0.0) {
            result = new Complex(Sfun.sinh(z.re));
        } else {
            result = new Complex(sinhx * cosy, coshx * siny);
            if (infiniteY) {
                result.im = Double.NaN;
                if (z.re == 0.0) {
                    result.re = 0.0;
                }
            }
            if (infiniteX) {
                result.re = z.re * cosy;
                result.im = z.re * siny;
                if (z.im == 0.0) {
                    result.im = 0.0;
                }
                if (infiniteY) {
                    result.re = z.im;
                }
            }
        }
        return result;
    }

    public static Complex cosh(Complex z) {
        if (z.im == 0.0) {
            return new Complex(Sfun.cosh(z.re));
        }
        double coshx = Sfun.cosh(z.re);
        double sinhx = Sfun.sinh(z.re);
        double cosy = Math.cos(z.im);
        double siny = Math.sin(z.im);
        boolean infiniteX = Double.isInfinite(coshx);
        boolean infiniteY = Double.isInfinite(z.im);
        Complex result = new Complex(coshx * cosy, sinhx * siny);
        if (infiniteY) {
            result.re = Double.NaN;
        }
        if (z.re == 0.0) {
            result.im = 0.0;
        } else if (infiniteX) {
            result.re = z.re * cosy;
            result.im = z.re * siny;
            if (z.im == 0.0) {
                result.im = 0.0;
            }
            if (Double.isNaN(z.im)) {
                result.re = z.re;
            } else if (infiniteY) {
                result.re = z.im;
            }
        }
        return result;
    }

    public static Complex tanh(Complex z) {
        double sinh2x = Sfun.sinh((double)2 * z.re);
        if (z.im == 0.0) {
            return new Complex(Sfun.tanh(z.re));
        }
        if (sinh2x == 0.0) {
            return new Complex(0.0, Math.tan(z.im));
        }
        double cosh2x = Sfun.cosh((double)2 * z.re);
        double cos2y = Math.cos((double)2 * z.im);
        double sin2y = Math.sin((double)2 * z.im);
        boolean infiniteX = Double.isInfinite(cosh2x);
        if (Double.isInfinite(z.im) || Double.isNaN(z.im)) {
            sin2y = Double.NaN;
            cos2y = Double.NaN;
        }
        if (infiniteX) {
            return new Complex(z.re > 0.0 ? 1 : -1);
        }
        double den = cosh2x + cos2y;
        return new Complex(sinh2x / den, sin2y / den);
    }

    public static Complex pow(Complex z, double x) {
        double absz = Complex.abs(z);
        Complex result = new Complex();
        if (absz == 0.0) {
            result = z;
        } else {
            double a = Complex.argument(z);
            double e = Math.pow(absz, x);
            result.re = e * Math.cos(x * a);
            result.im = e * Math.sin(x * a);
        }
        return result;
    }

    public static Complex asinh(Complex z) {
        Complex miz = new Complex(z.im, -z.re);
        Complex result = Complex.asin(miz);
        double rx = result.im;
        result.im = result.re;
        result.re = -rx;
        return result;
    }

    public static Complex acosh(Complex z) {
        Complex result = Complex.acos(z);
        double rx = -result.im;
        result.im = result.re;
        result.re = rx;
        if (result.re < 0.0 || Complex.isNegZero(result.re)) {
            result.re = -result.re;
            result.im = -result.im;
        }
        return result;
    }

    private static boolean isNegZero(double x) {
        return Double.doubleToLongBits(x) == negZeroBits;
    }

    public static Complex atanh(Complex z) {
        Complex miz = new Complex(z.im, -z.re);
        Complex result = Complex.atan(miz);
        double rx = result.im;
        result.im = result.re;
        result.re = -rx;
        return result;
    }

    public static Complex pow(Complex x, Complex y) {
        return Complex.exp(Complex.times(y, Complex.log(x)));
    }

    public String toString() {
        if (this.im == 0.0) {
            return String.valueOf(this.re);
        }
        if (this.re == 0.0) {
            return String.valueOf(String.valueOf(String.valueOf(this.im))).concat(String.valueOf(String.valueOf(suffix)));
        }
        String sign = this.im < 0.0 ? "" : "+";
        return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(String.valueOf(this.re)))).append(sign).append(String.valueOf(this.im)).append(suffix)));
    }

    public static Complex valueOf(String s) throws NumberFormatException {
        String input = s.trim();
        int iBeginNumber = 0;
        Complex z = new Complex();
        int state = 0;
        int sign = 1;
        boolean haveRealPart = false;
        block7: for (int k = 0; k < input.length(); ++k) {
            char ch = input.charAt(k);
            switch (ch) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    if (state == 0 || state == 1) {
                        state = 2;
                        continue block7;
                    }
                    if (state != 4) continue block7;
                    state = 5;
                    continue block7;
                }
                case '+': 
                case '-': {
                    int n = sign = ch == '+' ? 1 : -1;
                    if (state == 0) {
                        state = 1;
                        continue block7;
                    }
                    if (state == 4) {
                        state = 5;
                        continue block7;
                    }
                    if (!haveRealPart) {
                        z.re = Double.valueOf(input.substring(iBeginNumber, k));
                        haveRealPart = true;
                        iBeginNumber = k;
                        state = 1;
                        continue block7;
                    }
                    throw new NumberFormatException(input);
                }
                case '.': {
                    if (state == 0 || state == 1 || state == 2) {
                        state = 3;
                        continue block7;
                    }
                    throw new NumberFormatException(input);
                }
                case 'I': 
                case 'J': 
                case 'i': 
                case 'j': {
                    if (k + 1 != input.length()) {
                        throw new NumberFormatException(input);
                    }
                    if (state == 0 || state == 1) {
                        z.im = sign;
                        return z;
                    }
                    if (state == 2 || state == 3 || state == 5) {
                        z.im = Double.valueOf(input.substring(iBeginNumber, k));
                        return z;
                    }
                    throw new NumberFormatException(input);
                }
                case 'D': 
                case 'E': 
                case 'd': 
                case 'e': {
                    if (state == 2 || state == 3) {
                        state = 4;
                        continue block7;
                    }
                    throw new NumberFormatException(input);
                }
                default: {
                    throw new NumberFormatException(input);
                }
            }
        }
        if (!haveRealPart) {
            z.re = Double.valueOf(input);
            return z;
        }
        throw new NumberFormatException(input);
    }

    static {
        serialVersionUID = -633126172485117692L;
        suffix = "i";
        negZeroBits = Double.doubleToLongBits(-0.0);
    }
}

