/*
 * Decompiled with CFR 0.152.
 */
package ss.awt;

import com.imsl.math.Complex;
import java.awt.TextField;

public class TextUtils {
    public static int getTextFieldAsInt(TextField tf, int min, int defaultv, int max) {
        int val;
        try {
            val = Integer.valueOf(tf.getText().trim());
        }
        catch (NumberFormatException e) {
            val = defaultv;
        }
        if (val < min) {
            val = min;
        }
        if (max < val) {
            val = max;
        }
        tf.setText(String.valueOf(val));
        return val;
    }

    public static int getTextFieldAsInt(TextField tf, int min, int defaultv) {
        return TextUtils.getTextFieldAsInt(tf, min, defaultv, Integer.MAX_VALUE);
    }

    public static int getTextFieldAsInt(TextField tf, int defaultv) {
        return TextUtils.getTextFieldAsInt(tf, Integer.MIN_VALUE, defaultv, Integer.MAX_VALUE);
    }

    public static double getTextFieldAsDouble(TextField tf, double min, double defaultVal, double max) {
        double val;
        try {
            val = Float.valueOf(tf.getText().trim()).floatValue();
        }
        catch (NumberFormatException e) {
            val = defaultVal;
        }
        if (val < min) {
            val = min;
        }
        if (max < val) {
            val = max;
        }
        tf.setText(String.valueOf(val));
        return val;
    }

    public static double getTextFieldAsDouble(TextField tf, double min, double defaultv) {
        return TextUtils.getTextFieldAsDouble(tf, min, defaultv, Double.MAX_VALUE);
    }

    public static double getTextFieldAsDouble(TextField tf, double defaultv) {
        return TextUtils.getTextFieldAsDouble(tf, -1.7976931348623157E308, defaultv, Double.MAX_VALUE);
    }

    public static Complex getTextFieldAsComplex(TextField tf_re, TextField tf_im, Complex defaultv) {
        return new Complex(TextUtils.getTextFieldAsDouble(tf_re, defaultv.real()), TextUtils.getTextFieldAsDouble(tf_im, defaultv.imag()));
    }

    public static void setTextFieldWithComplex(TextField tf_re, TextField tf_im, Complex z) {
        tf_re.setText(String.valueOf(z.real()));
        tf_im.setText(String.valueOf(z.imag()));
    }
}

