/*
 * Decompiled with CFR 0.152.
 */
package booleanNet;

import java.awt.Button;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Label;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Random;

public class Engine {
    static int defaultK = 2;
    static Color color_on = Color.white;
    static Color color_newon = Color.yellow;
    static Color color_newoff = Color.red;
    static Color color_off = Color.black;
    static int log_multiplier = 20;
    int gridSize;
    int kauf;
    boolean[][] grid;
    boolean[][] new_grid;
    int[][][] xconnection;
    int[][][] yconnection;
    boolean[][][] bfunction;
    boolean is_net;
    int nIter = 0;
    Label ctLabel;
    Button button_cycle;
    Canvas canvas;
    Graphics g;
    static int graph_size = 200;
    ArrayList cycleTimeList;
    int cycleTime = -1;

    Engine(int gridSize) {
        this.gridSize = gridSize;
        this.kauf = defaultK;
        this.is_net = false;
        this.set(this.is_net);
        this.init_net();
    }

    public void set(boolean is_net) {
        this.is_net = is_net;
        this.set_graph(this.canvas);
    }

    public void init_net() {
        this.init_net(this.gridSize, this.kauf, null, null);
    }

    public void set_graph(Canvas canvas) {
        if (canvas == null) {
            return;
        }
        this.canvas = canvas;
        canvas.setSize(graph_size, graph_size);
        this.g = canvas.getGraphics();
        this.g.setColor(Color.black);
        this.g.drawRect(0, 0, graph_size, graph_size);
        this.g.setColor(Color.white);
        this.g.fillRect(1, 1, graph_size - 2, graph_size - 2);
        this.g.setColor(Color.lightGray);
        for (int i = 1; i < 10001; i *= 10) {
            int xy = (int)(Math.log(i) * (double)log_multiplier);
            this.g.drawLine(xy, graph_size, xy, 0);
            this.g.drawLine(0, graph_size - xy, graph_size, graph_size - xy);
        }
        this.g.setColor(Color.red);
    }

    public void init_net(int current_N, int current_K, Label cycleTimeVal, Button button_cycle) {
        this.gridSize = current_N;
        this.kauf = current_K;
        this.ctLabel = cycleTimeVal;
        this.button_cycle = button_cycle;
        this.new_grid = null;
        this.grid = null;
        this.init_grid();
        if (this.is_net) {
            this.set_connections();
            this.set_functions();
            this.cycleTimeList = new ArrayList(4 * current_N);
            this.cycleTimeList.add(this.flatten(this.grid));
            this.cycleTime = -1;
        }
        if (this.ctLabel != null) {
            this.ctLabel.setText("");
        }
    }

    public int get_cycle() {
        return this.cycleTime;
    }

    private BigInteger flatten(boolean[][] grid) {
        BigInteger big = BigInteger.valueOf(0L);
        BigInteger pow = BigInteger.valueOf((long)Math.pow(2.0, grid.length));
        for (int i = 0; i < grid.length; ++i) {
            long small = 0L;
            for (int j = 0; j < grid[i].length; ++j) {
                small = (long)2 * small + (long)(grid[i][j] ? 1 : 0);
            }
            big = big.multiply(pow);
            big = big.add(BigInteger.valueOf(small));
        }
        return big;
    }

    public void next() {
        if (this.is_net) {
            this.next_net();
        } else {
            this.init_grid();
        }
    }

    private void getCycleTime(boolean[][] grid) {
        if (!this.is_net) {
            return;
        }
        if (this.cycleTime > -1) {
            return;
        }
        if (this.nIter < 2) {
            return;
        }
        BigInteger flatGrid = this.flatten(grid);
        int i = this.cycleTimeList.lastIndexOf(flatGrid);
        if (i != -1) {
            this.cycleTime = Math.max(0, this.cycleTimeList.size() - i);
            this.ctLabel.setText(String.valueOf(this.cycleTime).concat(" after ").concat(String.valueOf(this.nIter)).concat(" iterations"));
            this.button_cycle.setLabel("Show cycle");
        } else {
            this.ctLabel.setText("??? after ".concat(String.valueOf(this.nIter)).concat(" iterations"));
        }
        this.cycleTimeList.add(flatGrid);
    }

    private void next_net() {
        this.grid = this.new_grid;
        ++this.nIter;
        this.getCycleTime(this.grid);
        this.new_grid = new boolean[this.gridSize][this.gridSize];
        for (int i = 0; i < this.grid.length; ++i) {
            for (int j = 0; j < this.grid[i].length; ++j) {
                this.new_grid[i][j] = this.next_bulb(i, j);
            }
        }
    }

    private boolean next_bulb(int i, int j) {
        int func_index = 0;
        for (int k = 0; k < this.kauf; ++k) {
            boolean input_bulb_state = this.grid[this.xconnection[i][j][k]][this.yconnection[i][j][k]];
            func_index = 2 * func_index + (input_bulb_state ? 0 : 1);
        }
        return this.bfunction[i][j][func_index];
    }

    private void init_grid() {
        Random rnd = new Random();
        this.grid = this.new_grid;
        this.new_grid = new boolean[this.gridSize][this.gridSize];
        for (int i = 0; i < this.gridSize; ++i) {
            for (int j = 0; j < this.gridSize; ++j) {
                this.new_grid[i][j] = rnd.nextBoolean();
            }
        }
        this.nIter = 0;
        if (this.grid == null) {
            this.grid = this.new_grid;
        }
    }

    private void set_connections() {
        Random rnd = new Random();
        this.xconnection = new int[this.gridSize][this.gridSize][this.kauf];
        this.yconnection = new int[this.gridSize][this.gridSize][this.kauf];
        for (int i = 0; i < this.grid.length; ++i) {
            for (int j = 0; j < this.grid[i].length; ++j) {
                for (int k = 0; k < this.kauf; ++k) {
                    this.xconnection[i][j][k] = rnd.nextInt(this.gridSize);
                    this.yconnection[i][j][k] = rnd.nextInt(this.gridSize);
                }
            }
        }
    }

    private void set_functions() {
        Random rnd = new Random();
        int nfunc = (int)Math.pow(2.0, Math.pow(2.0, this.kauf));
        this.bfunction = new boolean[this.gridSize][this.gridSize][nfunc];
        for (int i = 0; i < this.grid.length; ++i) {
            for (int j = 0; j < this.grid[i].length; ++j) {
                for (int k = 0; k < nfunc; ++k) {
                    this.bfunction[i][j][k] = rnd.nextBoolean();
                }
            }
        }
    }

    void paint(Graphics g, int canvasSize) {
        int socketSize = canvasSize / this.gridSize;
        int bulbSize = socketSize / 2;
        g.setColor(Color.black);
        g.fillRect(0, 0, canvasSize, canvasSize);
        for (int i = 0; i < this.grid.length; ++i) {
            for (int j = 0; j < this.grid[i].length; ++j) {
                if (this.new_grid[i][j]) {
                    if (this.grid[i][j]) {
                        g.setColor(color_on);
                    } else {
                        g.setColor(color_newon);
                    }
                } else if (this.grid[i][j]) {
                    g.setColor(color_newoff);
                } else {
                    g.setColor(color_off);
                }
                g.fillRect(i * socketSize + bulbSize - 2, j * socketSize + bulbSize - 2, bulbSize, bulbSize);
            }
        }
    }
}

