/*
 * Decompiled with CFR 0.152.
 */
package booleanNet;

import booleanNet.Engine;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Label;

public class QuarterCanvas
extends Canvas {
    private static int canvasSize = 200;
    private Engine engine;
    private int current_N;

    QuarterCanvas(int current_N) {
        this.engine = new Engine(current_N);
        this.current_N = current_N;
    }

    public Dimension getPreferredSize() {
        return new Dimension(canvasSize, canvasSize);
    }

    public void set_rnd() {
        this.engine.set(false);
    }

    public void set_net() {
        this.engine.set(true);
    }

    public void set_graph(Canvas canvas) {
        this.engine.set_graph(canvas);
    }

    public void redraw(int current_N, int current_K, Label cycleTimeVal, Button button_cycle) {
        this.engine.init_net(current_N, current_K, cycleTimeVal, button_cycle);
        this.current_N = current_N;
        this.repaint();
    }

    public void next_cycle(boolean all) {
        int nc = this.engine.get_cycle();
        int max_iter = this.current_N * this.current_N;
        if (nc == -1) {
            for (int n = 0; n < max_iter; ++n) {
                this.engine.next();
                this.repaint();
                if (this.engine.get_cycle() <= -1) continue;
                return;
            }
        } else {
            for (int n = 0; n < nc; ++n) {
                this.next();
            }
        }
    }

    public void next() {
        this.engine.next();
        ((Component)this).update(this.getGraphics());
        try {
            Thread.currentThread();
            Thread.sleep(150L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void paint(Graphics g) {
        this.engine.paint(g, canvasSize);
    }
}

