/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.io;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import javajs.api.GenericBinaryDocument;
import javajs.util.CompoundDocument;
import javajs.util.Lst;
import javajs.util.PT;
import javajs.util.Rdr;
import javajs.util.SB;
import org.jmol.api.Interface;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.viewer.FileManager;

public class JmolBinary {
    public FileManager fm;

    public JmolBinary set(FileManager fm) {
        this.fm = fm;
        return this;
    }

    public SB getSpartanData(InputStream is, String[] zipDirectory) {
        SB data = new SB();
        data.append("Zip File Directory: ").append("\n").append(Escape.eAS(zipDirectory, true)).append("\n");
        Hashtable<String, String> fileData = new Hashtable<String, String>();
        this.fm.vwr.getJzt().getAllZipData(is, new String[0], "", "Molecule", "__MACOSX", fileData);
        String prefix = "|";
        String outputData = (String)fileData.get(prefix + "output");
        if (outputData == null) {
            prefix = "|" + zipDirectory[1];
            outputData = (String)fileData.get(prefix + "output");
        }
        data.append(outputData);
        String[] files = this.getSpartanFileList(prefix, this.getSpartanDirs(outputData));
        for (int i = 2; i < files.length; ++i) {
            String name = files[i];
            if (fileData.containsKey(name)) {
                data.append((String)fileData.get(name));
                continue;
            }
            data.append(name + "\n");
        }
        return data;
    }

    public Object getSpartanFileList(String name, boolean isTypeCheckOnly) {
        String s;
        int pt = name.lastIndexOf(".spardir");
        String[] info = null;
        if (name.endsWith(".spardir.zip")) {
            info = new String[]{"SpartanSmol", "Directory Entry ", name + "|output"};
        } else {
            String[] stringArray;
            if (!(name = name.replace('\\', '/')).endsWith(".spardir") && name.indexOf(".spardir/") < 0) {
                return null;
            }
            if (name.lastIndexOf("/") > pt) {
                String[] stringArray2 = new String[7];
                stringArray2[0] = "SpartanSmol";
                stringArray2[1] = "Directory Entry ";
                stringArray2[2] = name + "/input";
                stringArray2[3] = name + "/archive";
                stringArray2[4] = name + "/parchive";
                stringArray2[5] = name + "/Molecule:asBinaryString";
                stringArray = stringArray2;
                stringArray2[6] = name + "/proparc";
            } else {
                String[] stringArray3 = new String[3];
                stringArray3[0] = "SpartanSmol";
                stringArray3[1] = "Directory Entry ";
                stringArray = stringArray3;
                stringArray3[2] = name + "/output";
            }
            info = stringArray;
        }
        if (isTypeCheckOnly) {
            return info;
        }
        String name00 = name;
        String header = info[1];
        String outputFileName = info[2];
        Hashtable<String, String> fileData = new Hashtable<String, String>();
        if (info.length == 3) {
            outputFileName = this.spartanGetObjectAsSections(outputFileName, header, fileData);
            fileData.put("OUTPUT", outputFileName);
            info = this.spartanFileList(name, (String)fileData.get(outputFileName));
            if (info.length == 3) {
                outputFileName = this.spartanGetObjectAsSections(info[2], header, fileData);
                fileData.put("OUTPUT", outputFileName);
                info = this.spartanFileList(info[1], (String)fileData.get(outputFileName));
            }
        }
        SB sb = new SB();
        if (fileData.get("OUTPUT") != null) {
            sb.append((String)fileData.get(fileData.get("OUTPUT")));
        }
        for (int i = 2; i < info.length; ++i) {
            name = info[i];
            name = this.spartanGetObjectAsSections(name, header, fileData);
            Logger.info("reading " + name);
            s = (String)fileData.get(name);
            sb.append(s);
        }
        s = sb.toString();
        if (this.fm.spardirCache == null) {
            this.fm.spardirCache = new Hashtable<String, byte[]>();
        }
        this.fm.spardirCache.put(name00.replace('\\', '/'), s.getBytes());
        return Rdr.getBR(s);
    }

    private String[] spartanFileList(String name, String outputFileData) {
        String[] dirNums = this.getSpartanDirs(outputFileData);
        if (dirNums.length == 0) {
            if (name.endsWith(".spardir")) {
                return this.getSpartanFileList(name, new String[]{"M0001"});
            }
            if (name.endsWith(".spardir.zip") && outputFileData.indexOf(".zip|output") >= 0) {
                String sname = name.replace('\\', '/');
                int pt = name.lastIndexOf(".spardir");
                pt = sname.lastIndexOf("/");
                sname = name + "|" + PT.rep(name.substring(pt + 1, name.length() - 4), "DROP_", "");
                return new String[]{"SpartanSmol", sname, sname + "/output"};
            }
        }
        return this.getSpartanFileList(name, dirNums);
    }

    private String[] getSpartanDirs(String outputFileData) {
        String[] stringArray;
        if (outputFileData == null) {
            return new String[0];
        }
        Lst<String> v = new Lst<String>();
        String lastToken = "";
        if (outputFileData.startsWith("java.io.FileNotFoundException") || outputFileData.startsWith("FILE NOT FOUND") || outputFileData.indexOf("<html") >= 0) {
            return new String[0];
        }
        try {
            StringTokenizer tokens = new StringTokenizer(outputFileData, " \t\r\n");
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken();
                if (token.equals(")")) {
                    v.addLast(lastToken);
                } else if (token.equals("Start-") && tokens.nextToken().equals("Molecule")) {
                    v.addLast(PT.split(tokens.nextToken(), "\"")[1]);
                } else if (token.equals("Molecules")) {
                    int n = PT.parseInt(lastToken);
                    for (int i = 1; i <= n; ++i) {
                        String s = "0000" + i;
                        v.addLast("M" + s.substring(s.length() - 4));
                    }
                }
                lastToken = token;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (v.size() == 0) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "M0001";
        } else {
            stringArray = v.toArray(new String[v.size()]);
        }
        return stringArray;
    }

    private String[] getSpartanFileList(String name, String[] dirNums) {
        String[] files = new String[2 + dirNums.length * 6];
        files[0] = "SpartanSmol";
        files[1] = "Directory Entry ";
        int pt = 2;
        if ((name = name.replace('\\', '/')).endsWith("/")) {
            name = name.substring(0, name.length() - 1);
        }
        String sep = name.equals("|") ? "" : (name.endsWith(".zip") ? "|" : "/");
        for (int i = 0; i < dirNums.length; ++i) {
            String path = name + sep;
            String s = dirNums[i];
            path = path + (PT.isDigit(s.charAt(0)) ? "Profile." + s : s) + "/";
            files[pt++] = path + "#JMOL_MODEL " + dirNums[i];
            files[pt++] = path + "input";
            files[pt++] = path + "archive";
            files[pt++] = path + "parchive";
            files[pt++] = path + "Molecule:asBinaryString";
            files[pt++] = path + "proparc";
        }
        return files;
    }

    private String spartanGetObjectAsSections(String name, String header, Map<String, String> fileData) {
        if (name == null) {
            return null;
        }
        String[] subFileList = null;
        boolean asBinaryString = false;
        String path = name.replace('\\', '/');
        if (name.indexOf(":asBinaryString") >= 0) {
            asBinaryString = true;
            name = name.substring(0, name.indexOf(":asBinaryString"));
        }
        SB sb = null;
        if (fileData.containsKey(path)) {
            return path;
        }
        if (path.indexOf("#JMOL_MODEL ") >= 0) {
            fileData.put(path, path + "\n");
            return path;
        }
        String fullName = name;
        if (name.indexOf("|") >= 0) {
            subFileList = PT.split(name, "|");
            name = subFileList[0];
        }
        BufferedInputStream bis = null;
        try {
            Object t = this.fm.getBufferedInputStreamOrErrorMessageFromName(name, fullName, false, false, null, false, true);
            if (t instanceof String) {
                fileData.put(path, (String)t + "\n");
                return path;
            }
            name = name.replace('\\', '/');
            bis = (BufferedInputStream)t;
            if (Rdr.isCompoundDocumentS(bis)) {
                CompoundDocument doc = (CompoundDocument)Interface.getInterface("javajs.util.CompoundDocument", this.fm.vwr, "file");
                doc.setDocStream(this.fm.vwr.getJzt(), bis);
                doc.getAllDataMapped(name, "Molecule", fileData);
            } else if (Rdr.isZipS(bis)) {
                this.fm.vwr.getJzt().getAllZipData(bis, subFileList, name, "Molecule", "__MACOSX", fileData);
            } else if (asBinaryString) {
                GenericBinaryDocument bd = (GenericBinaryDocument)Interface.getInterface("javajs.util.BinaryDocument", this.fm.vwr, "file");
                bd.setStream(bis, false);
                sb = new SB();
                if (header != null) {
                    sb.append("BEGIN Directory Entry " + path + "\n");
                }
                try {
                    while (true) {
                        sb.append(Integer.toHexString(bd.readByte() & 0xFF)).appendC(' ');
                    }
                }
                catch (Exception e1) {
                    sb.appendC('\n');
                    if (header != null) {
                        sb.append("\nEND Directory Entry " + path + "\n");
                    }
                    fileData.put(path, sb.toString());
                }
            } else {
                String line;
                BufferedReader br = Rdr.getBufferedReader(Rdr.isGzipS(bis) ? new BufferedInputStream(this.fm.vwr.getJzt().newGZIPInputStream(bis)) : bis, null);
                sb = new SB();
                if (header != null) {
                    sb.append("BEGIN Directory Entry " + path + "\n");
                }
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                    sb.appendC('\n');
                }
                br.close();
                if (header != null) {
                    sb.append("\nEND Directory Entry " + path + "\n");
                }
                fileData.put(path, sb.toString());
            }
        }
        catch (Exception ioe) {
            fileData.put(path, ioe.toString());
        }
        if (bis != null) {
            try {
                bis.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (!fileData.containsKey(path)) {
            fileData.put(path, "FILE NOT FOUND: " + path + "\n");
        }
        return path;
    }
}

