/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import javajs.util.P3;
import javajs.util.Quat;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.c.STR;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Chain;
import org.jmol.modelset.Structure;
import org.jmol.modelsetbio.Monomer;

public class PhosphorusMonomer
extends Monomer {
    protected static final byte P = 0;
    private static final byte[] phosphorusOffsets = new byte[]{0};
    private static float MAX_ADJACENT_PHOSPHORUS_DISTANCE = 8.0f;

    public final boolean isNucleic() {
        return true;
    }

    protected PhosphorusMonomer() {
    }

    static Monomer validateAndAllocateP(Chain chain, String group3, int seqcode, int firstIndex, int lastIndex, int[] specialAtomIndexes) {
        return firstIndex != lastIndex || specialAtomIndexes[13] != firstIndex ? null : new PhosphorusMonomer().set2(chain, group3, seqcode, firstIndex, lastIndex, phosphorusOffsets);
    }

    public boolean isDna() {
        return this.isDnaByID();
    }

    public boolean isRna() {
        return this.isRnaByID();
    }

    public boolean isPurine() {
        return this.isPurineByID();
    }

    public boolean isPyrimidine() {
        return this.isPyrimidineByID();
    }

    public Structure getStructure() {
        return this.chain;
    }

    @Override
    public STR getProteinStructureType() {
        return STR.NONE;
    }

    @Override
    boolean isConnectedAfter(Monomer possiblyPreviousMonomer) {
        return this.isCA2(possiblyPreviousMonomer);
    }

    protected boolean isCA2(Monomer possiblyPreviousMonomer) {
        if (possiblyPreviousMonomer == null) {
            return true;
        }
        float distance = this.getLeadAtom().distance((T3)possiblyPreviousMonomer.getLeadAtom());
        return distance <= MAX_ADJACENT_PHOSPHORUS_DISTANCE;
    }

    public Quat getQuaternion(char qType) {
        return this.getQuaternionP();
    }

    protected Quat getQuaternionP() {
        int i = this.monomerIndex;
        if (i <= 0 || i >= this.bioPolymer.monomerCount - 1) {
            return null;
        }
        Atom ptP = this.bioPolymer.monomers[i].getAtomFromOffsetIndex(0);
        Atom ptA = this.bioPolymer.monomers[i + 1].getAtomFromOffsetIndex(0);
        Atom ptB = this.bioPolymer.monomers[i - 1].getAtomFromOffsetIndex(0);
        if (ptP == null || ptA == null || ptB == null) {
            return null;
        }
        V3 vA = new V3();
        V3 vB = new V3();
        vA.sub2((T3)ptA, (T3)ptP);
        vB.sub2((T3)ptB, (T3)ptP);
        return Quat.getQuaternionFrameV((V3)vA, (V3)vB, null, (boolean)false);
    }

    @Override
    P3 getQuaternionFrameCenter(char qType) {
        return this.getAtomFromOffsetIndex(0);
    }

    public Object getHelixData(int tokType, char qType, int mStep) {
        return this.getHelixData2(tokType, qType, mStep);
    }
}

