/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.popup;

import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import javajs.api.GenericMenuInterface;
import javajs.api.SC;
import javajs.util.Lst;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.popup.PopupHelper;
import org.jmol.popup.PopupResource;
import org.jmol.util.Logger;

public abstract class GenericSwingPopup
implements GenericMenuInterface {
    protected PopupHelper helper;
    protected String strMenuStructure;
    protected boolean allowSignedFeatures;
    protected boolean isJS;
    protected boolean isApplet;
    protected boolean isSigned;
    protected boolean isWebGL;
    protected int thisx;
    protected int thisy;
    protected boolean isTainted = true;
    protected String menuName;
    protected SC popupMenu;
    protected SC thisPopup;
    protected Map<String, SC> htCheckbox = new Hashtable<String, SC>();
    protected Object buttonGroup;
    protected String currentMenuItemId;
    protected Map<String, SC> htMenus = new Hashtable<String, SC>();
    private Lst<SC> SignedOnly = new Lst();

    protected abstract Object getImageIcon(String var1);

    protected abstract void menuShowPopup(SC var1, int var2, int var3);

    protected abstract String menuSetCheckBoxOption(SC var1, String var2, String var3);

    protected abstract void appCheckItem(String var1, SC var2);

    protected abstract void appCheckSpecialMenu(String var1, SC var2, String var3);

    protected abstract String appFixLabel(String var1);

    protected abstract String appFixScript(String var1, String var2);

    protected abstract boolean appGetBooleanProperty(String var1);

    protected abstract String appGetMenuAsString(String var1);

    protected abstract boolean appIsSpecialCheckBox(SC var1, String var2, String var3, boolean var4);

    protected abstract void appRestorePopupMenu();

    protected abstract void appRunScript(String var1);

    protected abstract void appUpdateSpecialCheckBoxValue(SC var1, String var2, boolean var3);

    protected abstract void appUpdateForShow();

    protected void initSwing(String title, PopupResource bundle, Object applet, boolean isJS, boolean isSigned, boolean isWebGL) {
        this.isJS = isJS;
        this.isApplet = applet != null;
        this.isSigned = isSigned;
        this.isWebGL = isWebGL;
        this.allowSignedFeatures = !this.isApplet || isSigned;
        this.menuName = title;
        this.thisPopup = this.popupMenu = this.helper.menuCreatePopup(title, applet);
        this.htMenus.put(title, this.popupMenu);
        this.addMenuItems("", title, this.popupMenu, bundle);
        try {
            this.jpiUpdateComputedMenus();
        }
        catch (NullPointerException e) {
            // empty catch block
        }
    }

    protected void addMenuItems(String parentId, String key, SC menu, PopupResource popupResourceBundle) {
        String item;
        String id = parentId + "." + key;
        String value = popupResourceBundle.getStructure(key);
        if (Logger.debugging) {
            Logger.debug(id + " --- " + value);
        }
        if (value == null) {
            this.menuCreateItem(menu, "#" + key, "", "");
            return;
        }
        StringTokenizer st = new StringTokenizer(value);
        while (value.indexOf("@") >= 0) {
            String s = "";
            while (st.hasMoreTokens()) {
                s = s + " " + ((item = st.nextToken()).startsWith("@") ? popupResourceBundle.getStructure(item) : item);
            }
            value = s.substring(1);
            st = new StringTokenizer(value);
        }
        while (st.hasMoreTokens()) {
            item = st.nextToken();
            if (!this.checkKey(item)) continue;
            if ("-".equals(item)) {
                this.menuAddSeparator(menu);
                continue;
            }
            String label = popupResourceBundle.getWord(item);
            SC newItem = null;
            String script = "";
            boolean isCB = false;
            if ((label = this.appFixLabel(label == null ? item : label)).equals("null")) continue;
            if (item.indexOf("Menu") >= 0) {
                if (item.indexOf("more") < 0) {
                    this.helper.menuAddButtonGroup(null);
                }
                SC subMenu = this.menuNewSubMenu(label, id + "." + item);
                this.menuAddSubMenu(menu, subMenu);
                if (item.indexOf("Computed") < 0) {
                    this.addMenuItems(id, item, subMenu, popupResourceBundle);
                }
                this.appCheckSpecialMenu(item, subMenu, label);
                newItem = subMenu;
            } else if (item.endsWith("Checkbox") || (isCB = item.endsWith("CB") || item.endsWith("RD"))) {
                boolean isRadio;
                script = popupResourceBundle.getStructure(item);
                String basename = item.substring(0, item.length() - (!isCB ? 8 : 2));
                boolean bl = isRadio = isCB && item.endsWith("RD");
                if (script == null || script.length() == 0 && !isRadio) {
                    script = "set " + basename + " T/F";
                }
                newItem = this.menuCreateCheckboxItem(menu, label, basename + ":" + script, id + "." + item, false, isRadio);
                this.rememberCheckbox(basename, newItem);
                if (isRadio) {
                    this.helper.menuAddButtonGroup(newItem);
                }
            } else {
                script = popupResourceBundle.getStructure(item);
                if (script == null) {
                    script = item;
                }
                newItem = this.menuCreateItem(menu, label, script, id + "." + item);
            }
            this.htMenus.put(item, newItem);
            if (item.startsWith("SIGNED")) {
                this.SignedOnly.addLast(newItem);
                if (!this.allowSignedFeatures) {
                    this.menuEnable(newItem, false);
                }
            }
            this.appCheckItem(item, newItem);
        }
    }

    protected void updateSignedAppletItems() {
        int i = this.SignedOnly.size();
        while (--i >= 0) {
            this.menuEnable((SC)this.SignedOnly.get(i), this.allowSignedFeatures);
        }
    }

    private boolean checkKey(String key) {
        return key.indexOf(this.isApplet ? "JAVA" : "APPLET") < 0 && (!this.isWebGL || key.indexOf("NOGL") < 0);
    }

    private void rememberCheckbox(String key, SC checkboxMenuItem) {
        this.htCheckbox.put(key + "::" + this.htCheckbox.size(), checkboxMenuItem);
    }

    protected void updateButton(SC b, String entry, String script) {
        String[] ret = new String[]{entry};
        Object icon = this.getEntryIcon(ret);
        entry = ret[0];
        b.init(entry, icon, script, this.thisPopup);
        this.isTainted = true;
    }

    protected Object getEntryIcon(String[] ret) {
        String entry = ret[0];
        if (!entry.startsWith("<")) {
            return null;
        }
        int pt = entry.indexOf(">");
        ret[0] = entry.substring(pt + 1);
        String fileName = entry.substring(1, pt);
        return this.getImageIcon(fileName);
    }

    protected SC addMenuItem(SC menuItem, String entry) {
        return this.menuCreateItem(menuItem, entry, "", null);
    }

    protected void menuSetLabel(SC m, String entry) {
        m.setText(entry);
        this.isTainted = true;
    }

    private void menuSetCheckBoxValue(SC source) {
        boolean isSelected = source.isSelected();
        String what = source.getActionCommand();
        this.checkForCheckBoxScript(source, what, isSelected);
        this.appUpdateSpecialCheckBoxValue(source, what, isSelected);
        this.isTainted = true;
    }

    @Override
    public void menuClickCallback(SC source, String script) {
        this.processClickCallback(source, script);
    }

    protected void processClickCallback(SC source, String script) {
        this.appRestorePopupMenu();
        if (script == null || script.length() == 0) {
            return;
        }
        if (script.equals("MAIN")) {
            this.show(this.thisx, this.thisy, true);
            return;
        }
        String id = this.menuGetId(source);
        if (id != null) {
            script = this.appFixScript(id, script);
            this.currentMenuItemId = id;
        }
        this.appRunScript(script);
    }

    @Override
    public void menuCheckBoxCallback(SC source) {
        this.appRestorePopupMenu();
        this.menuSetCheckBoxValue(source);
        String id = this.menuGetId(source);
        if (id != null) {
            this.currentMenuItemId = id;
        }
    }

    private void checkForCheckBoxScript(SC item, String what, boolean TF) {
        if (!item.isEnabled()) {
            return;
        }
        if (what.indexOf("##") < 0) {
            int pt = what.indexOf(":");
            if (pt < 0) {
                Logger.error("check box " + item + " IS " + what);
                return;
            }
            String basename = what.substring(0, pt);
            if (this.appIsSpecialCheckBox(item, basename, what, TF)) {
                return;
            }
            if ((pt = (what = what.substring(pt + 1)).indexOf("|")) >= 0) {
                what = (TF ? what.substring(0, pt) : what.substring(pt + 1)).trim();
            }
            what = PT.rep(what, "T/F", TF ? " TRUE" : " FALSE");
        }
        this.appRunScript(what);
    }

    protected SC menuCreateItem(SC menu, String entry, String script, String id) {
        SC item = this.helper.getMenuItem(entry);
        item.addActionListener(this.helper);
        return this.newMenuItem(item, menu, entry, script, id);
    }

    protected SC menuCreateCheckboxItem(SC menu, String entry, String basename, String id, boolean state, boolean isRadio) {
        SC jmi = isRadio ? this.helper.getRadio(entry) : this.helper.getCheckBox(entry);
        jmi.setSelected(state);
        jmi.addItemListener(this.helper);
        return this.newMenuItem(jmi, menu, entry, basename, id);
    }

    protected void menuAddSeparator(SC menu) {
        menu.add(this.helper.getMenuItem(null));
        this.isTainted = true;
    }

    protected SC menuNewSubMenu(String entry, String id) {
        SC jm = this.helper.getMenu(entry);
        this.updateButton(jm, entry, null);
        jm.setName(id);
        jm.setAutoscrolls(true);
        return jm;
    }

    protected void menuRemoveAll(SC menu, int indexFrom) {
        if (indexFrom <= 0) {
            menu.removeAll();
        } else {
            int i = menu.getComponentCount();
            while (--i >= indexFrom) {
                menu.remove(i);
            }
        }
        this.isTainted = true;
    }

    private SC newMenuItem(SC item, SC menu, String text, String script, String id) {
        this.updateButton(item, text, script);
        if (id != null && id.startsWith("Focus")) {
            item.addMouseListener(this.helper);
            id = menu.getName() + "." + id;
        }
        item.setName(id == null ? menu.getName() + "." : id);
        this.menuAddItem(menu, item);
        return item;
    }

    protected SC setText(String item, String text) {
        SC m = this.htMenus.get(item);
        if (m != null) {
            m.setText(text);
        }
        return m;
    }

    private void menuAddItem(SC menu, SC item) {
        menu.add(item);
        this.isTainted = true;
    }

    protected void menuAddSubMenu(SC menu, SC subMenu) {
        this.menuAddItem(menu, subMenu);
    }

    protected void menuEnable(SC component, boolean enable) {
        if (component == null || component.isEnabled() == enable) {
            return;
        }
        component.setEnabled(enable);
    }

    protected String menuGetId(SC menu) {
        return menu.getName();
    }

    protected void menuSetAutoscrolls(SC menu) {
        menu.setAutoscrolls(true);
        this.isTainted = true;
    }

    protected int menuGetListPosition(SC item) {
        SC p = (SC)item.getParent();
        int i = p.getComponentCount();
        while (--i >= 0 && this.helper.getSwingComponent(p.getComponent(i)) != item) {
        }
        return i;
    }

    protected void show(int x, int y, boolean doPopup) {
        this.thisx = x;
        this.thisy = y;
        this.appUpdateForShow();
        this.updateCheckBoxesForShow();
        if (doPopup) {
            this.menuShowPopup(this.popupMenu, this.thisx, this.thisy);
        }
    }

    private void updateCheckBoxesForShow() {
        for (Map.Entry<String, SC> entry : this.htCheckbox.entrySet()) {
            String key = entry.getKey();
            SC item = entry.getValue();
            String basename = key.substring(0, key.indexOf(":"));
            boolean b = this.appGetBooleanProperty(basename);
            if (item.isSelected() == b) continue;
            item.setSelected(b);
            this.isTainted = true;
        }
    }

    @Override
    public String jpiGetMenuAsString(String title) {
        this.appUpdateForShow();
        int pt = title.indexOf("|");
        if (pt >= 0) {
            String type = title.substring(pt);
            title = title.substring(0, pt);
            if (type.indexOf("current") >= 0) {
                SB sb = new SB();
                SC menu = this.htMenus.get(this.menuName);
                this.menuGetAsText(sb, 0, menu, "PopupMenu");
                return sb.toString();
            }
        }
        return this.appGetMenuAsString(title);
    }

    private void menuGetAsText(SB sb, int level, SC menu, String menuName) {
        String name = menuName;
        Object[] subMenus = menu.getComponents();
        String flags = null;
        String script = null;
        String text = null;
        char key = 'S';
        for (int i = 0; i < subMenus.length; ++i) {
            SC m = this.helper.getSwingComponent(subMenus[i]);
            int type = this.helper.getItemType(m);
            switch (type) {
                case 4: {
                    key = 'M';
                    name = m.getName();
                    flags = "enabled:" + m.isEnabled();
                    text = m.getText();
                    script = null;
                    break;
                }
                case 0: {
                    key = 'S';
                    text = null;
                    script = null;
                    flags = null;
                    break;
                }
                default: {
                    key = 'I';
                    flags = "enabled:" + m.isEnabled();
                    if (type == 2 || type == 3) {
                        flags = flags + ";checked:" + m.isSelected();
                    }
                    script = this.appFixScript(m.getName(), m.getActionCommand());
                    name = m.getName();
                    text = m.getText();
                }
            }
            GenericSwingPopup.addItemText(sb, key, level, name, text, script, flags);
            if (type != 2) continue;
            this.menuGetAsText(sb, level + 1, this.helper.getSwingComponent(m.getPopupMenu()), name);
        }
    }

    private static void addItemText(SB sb, char type, int level, String name, String label, String script, String flags) {
        sb.appendC(type).appendI(level).appendC('\t').append(name);
        if (label == null) {
            sb.append(".\n");
            return;
        }
        sb.append("\t").append(label).append("\t").append(script == null || script.length() == 0 ? "-" : script).append("\t").append(flags).append("\n");
    }

    protected static int convertToMegabytes(long num) {
        if (num <= 0x7FFFFFFFFFF7FFFFL) {
            num += 524288L;
        }
        return (int)(num / 0x100000L);
    }
}

