/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.minimize.forcefield;

import javajs.util.Lst;
import org.jmol.minimize.MinAngle;
import org.jmol.minimize.forcefield.Calculation;

class MMFFAngleCalc
extends Calculation {
    static final double CB = -0.006981317007977318;

    MMFFAngleCalc() {
    }

    void setData(Lst<Object[]> calc, MinAngle angle) {
        Object data = this.calcs.getParameterObj(angle);
        if (data == null) {
            return;
        }
        calc.addLast((Object)new Object[]{angle.data, data, angle.key});
    }

    @Override
    double compute(Object[] dataIn) {
        this.key = (Integer)dataIn[2];
        this.getPointers(dataIn);
        double ka = this.dData[0];
        double t0 = this.dData[1];
        this.calcs.setAngleVariables(this);
        double dt = this.theta * 57.29577951308232 - t0;
        if (t0 == 180.0) {
            this.energy = 143.9325 * ka * (1.0 + Math.cos(this.theta));
            if (this.calcs.gradients) {
                this.dE = -143.9325 * ka * Math.sin(this.theta);
            }
        } else {
            this.energy = 0.021922 * ka * Math.pow(dt, 2.0) * (1.0 + -0.006981317007977318 * dt);
            if (this.calcs.gradients) {
                this.dE = 0.021922 * ka * dt * (2.0 + -0.020943951023931956 * dt);
            }
        }
        if (this.calcs.gradients) {
            this.calcs.addForces(this, 3);
        }
        if (this.calcs.logging) {
            this.calcs.appendLogData(this.calcs.getDebugLine(1, this));
        }
        return this.energy;
    }
}

