%% Reset

clear all
close all
clc

addpath ./src/
addpath ./mex/
addpath ./utils/

%% Load the data

[FV.vertices, FV.faces] = read_ply('./data/dino/dino.ply');

load ./data/dino/dino_sym_indices

%% Compute the distances between symmetric vertices

options.verbose = true;
Dsym_vertex     = compute_dist_sym(FV, sym_indices, options);

clear options

%% Save

save ./save/dsym/DsymDino Dsym_vertex