%% Reset

clear all
close all
clc

addpath ./src/
addpath ./mex/
addpath ./utils/

addpath(genpath('dwnld'))

%% Load the data

[FV.vertices, FV.faces] = read_ply('00022_20070307_02486_neutral_face05.ply');
sym_indices             = read_symlist_BFM('face05_symlist.txt');

%% Compute the distances between symmetric vertices

options.verbose = true;
Dsym_vertex     = compute_dist_sym(FV, sym_indices, options);

clear options

%% Save

save ./save/dsym/DsymScannedFace Dsym_vertex