%% Reset

clear all
close all
clc

addpath ./src/
addpath ./mex/
addpath ./utils/

%% Choose the parameters

Nkeypoints = 50;

%% Load the data

[FV.vertices, FV.faces] = read_ply('./data/buddha/happy_buddha.ply');

%% Segment the mesh

options.verbose                         = true;
options.seeds                           = [];
[sampled_keypoints, I_vertex_nkeypoint] = segment_mesh_uni(FV, Nkeypoints, options);

clear options

%% Display the results

figure

p = patch(FV);

set(p, 'AmbientStrength', 0, 'DiffuseStrength', 1, 'SpecularStrength', 0, 'FaceLighting', 'phong');
light('Position', [0 0 1], 'Style', 'infinite');
title('Uniform segmentation')

hold on
axis equal
axis off

map = jet(Nkeypoints);
map = map(randperm(Nkeypoints), :);

cdata = zeros(size(FV.vertices, 1), 3);

for i = 1: Nkeypoints
    tmp_indices             = find(I_vertex_nkeypoint(:, Nkeypoints) == i);
    cdata(tmp_indices, 1)   = map(i, 1);
    cdata(tmp_indices, 2)   = map(i, 2);
    cdata(tmp_indices, 3)   = map(i, 3);
end

set(p, 'FaceColor', 'interp', 'FaceVertexCData', cdata, 'LineStyle', 'none')

clear cdata i p map tmp_indices