function featurepoints = read_featurepoints_BFM(file, sym_indices, type)
%   Copyright (c) 2013, Arnaud Dessein (University of York)

% Open the file
fid = fopen(file, 'r');

% Read the file
fgetl(fid); fgetl(fid); fgetl(fid);
featurepoints = fscanf(fid, '%d %*f %*f %*f %*d %*d %*s', [1 inf]).';

% Get the type
if nargin > 2
   switch type
       case 'eyes'
           featurepoints = featurepoints([34, 64]);
       otherwise
           error('Unknown type of feature points');
   end
end

% Fix symmetry
if nargin > 1 && ~isempty(sym_indices)
    
    sym_featurepoints = zeros(length(featurepoints), 2);
    
    k = 0;
    while ~isempty(featurepoints)
        k                           = k + 1;
        [i j]                       = find(sym_indices == featurepoints(1), 1);
        l                           = find(featurepoints == sym_indices(i, 3 - j));
        sym_featurepoints(k, j)     = featurepoints(1);
        sym_featurepoints(k, 3 - j) = featurepoints(l);
        featurepoints(l)            = [];
        if l ~= 1
            featurepoints(1) = [];
        end
    end
    
    sym_featurepoints(k + 1: end, :)    = [];
    featurepoints                       = sym_featurepoints;
    
end

% Close the file
fclose(fid);

end