%% Reset

clear all
close all
clc

%% Compile the code for fast marching

% Filenames
files = {                                                       ...
    'perform_front_propagation_mesh.cpp',                       ...
    'gw/gw_core/GW_Config.cpp',                                 ...
    'gw/gw_core/GW_FaceIterator.cpp',                           ...
    'gw/gw_core/GW_SmartCounter.cpp',                           ...
    'gw/gw_core/GW_VertexIterator.cpp',                         ...
    'gw/gw_core/GW_Face.cpp',                                   ...
    'gw/gw_core/GW_Mesh.cpp',                                   ...
    'gw/gw_core/GW_Vertex.cpp',                                 ...
    'gw/gw_geodesic/GW_GeodesicFace.cpp',                       ...                                              
    'gw/gw_geodesic/GW_GeodesicMesh.cpp',                       ...                                 
    'gw/gw_geodesic/GW_GeodesicPath.cpp',                       ...                       
    'gw/gw_geodesic/GW_GeodesicPoint.cpp',                      ...           
    'gw/gw_geodesic/GW_TriangularInterpolation_Cubic.cpp',      ...      
    'gw/gw_geodesic/GW_GeodesicVertex.cpp',                     ...  
    'gw/gw_geodesic/GW_TriangularInterpolation_Linear.cpp', 	...
    'gw/gw_geodesic/GW_TriangularInterpolation_Quadratic.cpp',  ...
};

% Directory
dir = './mex/fm/';

% Build the command
cmd = 'mex -outdir ./mex/';
for i=1:length(files)
    cmd = cat(2, cmd, ' ', dir, files{i});
end

% Evaluate the command
eval(cmd);

clear cmd dir files i