%% Reset

clear all
close all
clc

addpath ./src/
addpath ./mex/
addpath ./utils/

addpath(genpath('dwnld'))

%% Load the data

load 01_MorphableModel

FV.faces    = tl;
FV.vertices = reshape(double(shapeMU.'), length(shapeMU) / 3, 3);
sym_indices = read_symlist_BFM('face05_symlist.txt');

clear segMB segMM segbin shapeEV shapeMU shapePC texEV texMU texPC tl

%% Compute the distances between symmetric vertices

options.verbose = true;
Dsym_vertex     = compute_dist_sym(FV, sym_indices, options);

clear options

%% Save

save ./save/dsym/DsymMeanFace Dsym_vertex