%% Reset

clear all
close all
clc

addpath ./src/
addpath ./mex/
addpath ./utils/

addpath(genpath('dwnld'))

%% Choose the parameters

Nkeypoints = 200;

%% Load the data

[FV.vertices, FV.faces] = read_ply('00022_20070307_02486_neutral_face05.ply');

sym_indices         = read_symlist_BFM('face05_symlist.txt');
sym_featurepoints   = read_featurepoints_BFM('Farkas_face05.fp', sym_indices);
featurepoints       = read_featurepoints_BFM('Farkas_face05.fp');

load ./save/dsym/DsymScannedFace

%% Segment the mesh

options.verbose                                     = true;
[sampled_keypoints, I_vertex_nkeypoint]             = segment_mesh_uni(FV, Nkeypoints, options);
options.seeds                                       = featurepoints;
[sampled_keypoints_seed, I_vertex_nkeypoint_seed]   = segment_mesh_uni(FV, Nkeypoints, options);

clear options

options.verbose                                             = true;
options.Dsym_vertex                                         = Dsym_vertex;
[sampled_sym_keypoints, Isym_vertex_nkeypoint]              = segment_mesh_uni_sym(FV, Nkeypoints, sym_indices, options);
options.sym_seeds                                           = sym_featurepoints;
[sampled_sym_keypoints_seed, Isym_vertex_nkeypoint_seed]    = segment_mesh_uni_sym(FV, Nkeypoints, sym_indices, options);

clear options

%% Display the results

figure

subplot(2, 2, 1)

map = jet(Nkeypoints);
map = map(randperm(Nkeypoints), :);

p = patch(FV);

set(p, 'AmbientStrength', 0, 'DiffuseStrength', 1, 'SpecularStrength', 0, 'FaceLighting', 'phong');
light('Position', [0 0 1], 'Style', 'infinite');
title('Asymmetric uniform segmentation with no seeds')

hold on
axis equal
axis off

cdata = zeros(size(FV.vertices, 1), 3);

for i = 1: Nkeypoints
    tmp_indices             = find(I_vertex_nkeypoint(:, Nkeypoints) == i);
    cdata(tmp_indices, 1)   = map(i, 1);
    cdata(tmp_indices, 2)   = map(i, 2);
    cdata(tmp_indices, 3)   = map(i, 3);
end

set(p, 'FaceColor', 'interp', 'FaceVertexCData', cdata, 'LineStyle', 'none')

subplot(2, 2, 3)

map = jet(Nkeypoints);
map = map(randperm(Nkeypoints), :);

p = patch(FV);

set(p, 'AmbientStrength', 0, 'DiffuseStrength', 1, 'SpecularStrength', 0, 'FaceLighting', 'phong');
light('Position', [0 0 1], 'Style', 'infinite');
title('Asymmetric uniform segmentation with seeds')

hold on
axis equal
axis off

cdata = zeros(size(FV.vertices, 1), 3);

for i = 1: Nkeypoints
    tmp_indices             = find(I_vertex_nkeypoint_seed(:, Nkeypoints) == i);
    cdata(tmp_indices, 1)   = map(i, 1);
    cdata(tmp_indices, 2)   = map(i, 2);
    cdata(tmp_indices, 3)   = map(i, 3);
end

set(p, 'FaceColor', 'interp', 'FaceVertexCData', cdata, 'LineStyle', 'none')

subplot(2, 2, 2)

Nsym_keypoints = size(sampled_sym_keypoints, 1);

map = jet(Nsym_keypoints);
map = map(randperm(Nsym_keypoints), :);

p = patch(FV);

set(p, 'AmbientStrength', 0, 'DiffuseStrength', 1, 'SpecularStrength', 0, 'FaceLighting', 'phong');
light('Position', [0 0 1], 'Style', 'infinite');
title('Symmetric uniform segmentation with no seeds')

hold on
axis equal
axis off
  
cdata = zeros(size(FV.vertices, 1), 3);

for i = 1: Nsym_keypoints
    tmp_indices                             = find(Isym_vertex_nkeypoint(:, Nsym_keypoints) == i);
    cdata(sym_indices(tmp_indices, :), 1)   = map(i, 1);
    cdata(sym_indices(tmp_indices, :), 2)   = map(i, 2);
    cdata(sym_indices(tmp_indices, :), 3)   = map(i, 3);
end

set(p, 'FaceColor', 'interp', 'FaceVertexCData', cdata, 'LineStyle', 'none')

subplot(2, 2, 4)

Nsym_keypoints = size(sampled_sym_keypoints_seed, 1);

map = jet(Nsym_keypoints);
map = map(randperm(Nsym_keypoints), :);

p = patch(FV);

set(p, 'AmbientStrength', 0, 'DiffuseStrength', 1, 'SpecularStrength', 0, 'FaceLighting', 'phong');
light('Position', [0 0 1], 'Style', 'infinite');
title('Symmetric uniform segmentation with seeds')

hold on
axis equal
axis off
  
cdata = zeros(size(FV.vertices, 1), 3);

for i = 1: Nsym_keypoints
    tmp_indices                             = find(Isym_vertex_nkeypoint_seed(:, Nsym_keypoints) == i);
    cdata(sym_indices(tmp_indices, :), 1)   = map(i, 1);
    cdata(sym_indices(tmp_indices, :), 2)   = map(i, 2);
    cdata(sym_indices(tmp_indices, :), 3)   = map(i, 3);
end

set(p, 'FaceColor', 'interp', 'FaceVertexCData', cdata, 'LineStyle', 'none')

clear cdata i p map tmp_indices Nsym_keypoints